<?php

namespace Liteerp\Branch\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use Liteerp\Branch\Interfaces\BranchRepositoryInterface;

class BranchPublicController extends BaseController
{
    // use BranchWorkflow;

    /**
     * Constructor.
     *
     * @param type \Liteerp\Branch\Interfaces\BranchRepositoryInterface $branch
     *
     * @return type
     */
    public function __construct(BranchRepositoryInterface $branch)
    {
        $this->repository = $branch;
        parent::__construct();
    }

    /**
     * Show branch's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $branches = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$branch::$branch.names'))
            ->view('$branch::public.branch.index')
            ->data(compact('$branches'))
            ->output();
    }

    /**
     * Show branch's list based on a type.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function list($type = null)
    {
        $branches = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$branch::$branch.names'))
            ->view('$branch::public.branch.index')
            ->data(compact('$branches'))
            ->output();
    }

    /**
     * Show branch.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $branch = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->response->title($$branch->name . trans('$branch::$branch.name'))
            ->view('$branch::public.branch.show')
            ->data(compact('$branch'))
            ->output();
    }

}
