<?php

namespace Liteerp\Branch\Policies;

use Litepie\User\Contracts\UserPolicy;
use Liteerp\Branch\Models\Branch;

class BranchPolicy
{

    /**
     * Determine if the given user can view the branch.
     *
     * @param UserPolicy $user
     * @param Branch $branch
     *
     * @return bool
     */
    public function view(UserPolicy $user, Branch $branch)
    {
        if ($user->canDo('branch.branch.view') && $user->isAdmin()) {
            return true;
        }

        return $branch->user_id == user_id() && $branch->user_type == user_type();
    }

    /**
     * Determine if the given user can create a branch.
     *
     * @param UserPolicy $user
     * @param Branch $branch
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('branch.branch.create');
    }

    /**
     * Determine if the given user can update the given branch.
     *
     * @param UserPolicy $user
     * @param Branch $branch
     *
     * @return bool
     */
    public function update(UserPolicy $user, Branch $branch)
    {
        if ($user->canDo('branch.branch.edit') && $user->isAdmin()) {
            return true;
        }

        return $branch->user_id == user_id() && $branch->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given branch.
     *
     * @param UserPolicy $user
     * @param Branch $branch
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Branch $branch)
    {
        return $branch->user_id == user_id() && $branch->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given branch.
     *
     * @param UserPolicy $user
     * @param Branch $branch
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Branch $branch)
    {
        if ($user->canDo('branch.branch.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given branch.
     *
     * @param UserPolicy $user
     * @param Branch $branch
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Branch $branch)
    {
        if ($user->canDo('branch.branch.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
