<?php

namespace Liteerp\Branch\Providers;

use Illuminate\Support\ServiceProvider;

class BranchServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'branch');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'branch');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('liteerp.branch', function ($app) {
            return $this->app->make('Liteerp\Branch\Branch');
        });

                // Bind Branch to repository
        $this->app->bind(
            'Liteerp\Branch\Interfaces\BranchRepositoryInterface',
            \Liteerp\Branch\Repositories\Eloquent\BranchRepository::class
        );

        $this->app->register(\Liteerp\Branch\Providers\AuthServiceProvider::class);
        
        $this->app->register(\Liteerp\Branch\Providers\RouteServiceProvider::class);
                
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['liteerp.branch'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('liteerp/branch.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/branch')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/branch')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
