<?php

namespace Liteerp\Branch\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class BranchTransformer extends TransformerAbstract
{
    public function transform(\Liteerp\Branch\Models\Branch $branch)
    {
        return [
            'id'                => $branch->getRouteKey(),
            'key'               => [
                'public'    => $branch->getPublicKey(),
                'route'     => $branch->getRouteKey(),
            ], 
            'id'                => $branch->id,
            'company_id'        => $branch->company_id,
            'name'              => $branch->name,
            'email'             => $branch->email,
            'password'          => $branch->password,
            'status'            => $branch->status,
            'api_token'         => $branch->api_token,
            'remember_token'    => $branch->remember_token,
            'mobile'            => $branch->mobile,
            'phone'             => $branch->phone,
            'address'           => $branch->address,
            'street'            => $branch->street,
            'city'              => $branch->city,
            'district'          => $branch->district,
            'state'             => $branch->state,
            'country'           => $branch->country,
            'photo'             => $branch->photo,
            'web'               => $branch->web,
            'permissions'       => $branch->permissions,
            'deleted_at'        => $branch->deleted_at,
            'created_at'        => $branch->created_at,
            'updated_at'        => $branch->updated_at,
            'url'               => [
                'public'    => trans_url('branch/'.$branch->getPublicKey()),
                'user'      => guard_url('branch/branch/'.$branch->getRouteKey()),
            ], 
            'status'            => trans('app.'.$branch->status),
            'created_at'        => format_date($branch->created_at),
            'updated_at'        => format_date($branch->updated_at),
        ];
    }
}