<?php

namespace Category\Category\Http\Controllers;

use App\Http\Controllers\UserController as UserController;
use Form;
use Category\Category\Http\Requests\CategoryUserRequest;
use Category\Category\Interfaces\CategoryRepositoryInterface;
use Category\Category\Models\Category;

class CategoryUserController extends UserController
{
    /**
     * Initialize category controller.
     *
     * @param type CategoryRepositoryInterface $category
     *
     * @return type
     */
    public function __construct(CategoryRepositoryInterface $category)
    {
        $this->repository = $category;
        parent::__construct();
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(CategoryUserRequest $request)
    {
        $this->repository->pushCriteria(new \Lavalite\Category\Repositories\Criteria\CategoryUserCriteria());
        $categories = $this->repository->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();

        $this->theme->prependTitle(trans('category::category.names').' :: ');

        return $this->theme->of('category::user.category.index', compact('categories'))->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     * @param Category $category
     *
     * @return Response
     */
    public function show(CategoryUserRequest $request, Category $category)
    {
        Form::populate($category);

        return $this->theme->of('category::user.category.show', compact('category'))->render();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(CategoryUserRequest $request)
    {

        $category = $this->repository->newInstance([]);
        Form::populate($category);

        return $this->theme->of('category::user.category.create', compact('category'))->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(CategoryUserRequest $request)
    {
        try {
            $attributes = $request->all();
            $attributes['user_id'] = user_id();
            $category = $this->repository->create($attributes);

            $this->responseCode = 201;
            $this->responseMessage = trans('messages.success.created', ['Module' => trans('category::category.name')]);
            $this->responseRedirect = trans_url('/user/category/category');
            return $this -> respond($request);
        } catch (Exception $e) {
            redirect()->back()->withInput()->with('message', $e->getMessage())->with('code', 400);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Request $request
     * @param Category $category
     *
     * @return Response
     */
    public function edit(CategoryUserRequest $request, Category $category)
    {

        Form::populate($category);

        return $this->theme->of('category::user.category.edit', compact('category'))->render();
    }

    /**
     * Update the specified resource.
     *
     * @param Request $request
     * @param Category $category
     *
     * @return Response
     */
    public function update(CategoryUserRequest $request, Category $category)
    {
        try {
            $this->repository->update($request->all(), $category->getRouteKey());
            $this->responseCode = 204;
            $this->responseMessage = trans('messages.success.updated', ['Module' => trans('category::category.name')]);
            $this->responseRedirect = trans_url('/user/category/category');
            return $this -> respond($request);
        } catch (Exception $e) {
            redirect()->back()->withInput()->with('message', $e->getMessage())->with('code', 400);
        }
    }

    /**
     * Remove the specified resource.
     *
     * @param int $id
     *
     * @return Response
     */
    public function destroy(CategoryUserRequest $request, Category $category)
    {
        try {
            $this->repository->delete($category->getRouteKey());
            $this->responseCode = 204;
            $this->responseMessage = trans('messages.success.deleted', ['Module' => trans('category::category.name')]);
            $this->responseRedirect = trans_url('/user/category/category');
            return $this -> respond($request);
        } catch (Exception $e) {

            redirect()->back()->withInput()->with('message', $e->getMessage())->with('code', 400);

        }
    }
}
