<?php

// Admin routes for category
Route::group(['prefix' => trans_setlocale().'/admin/category', 'middleware' => ['web', 'auth.role:admin']], function () {
    Route::resource('category', 'Category\Category\Http\Controllers\CategoryAdminController');
});

// User routes for category
Route::group(['prefix' => trans_setlocale().'/user/category', 'middleware' => ['web', 'auth.role:user']], function () {
    Route::resource('category', 'Category\Category\Http\Controllers\CategoryUserController');
});

// Public routes for category
Route::group(['prefix' => trans_setlocale(), 'middleware' => ['web']], function () {
    Route::get('category/category', 'Category\Category\Http\Controllers\CategoryPublicController@index');
    Route::get('category/category/{slug?}', 'Category\Category\Http\Controllers\CategoryPublicController@show');
});
