<?php

namespace Category\Category\Providers;

use Illuminate\Support\ServiceProvider;

class CategoryServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../../../resources/views', 'category');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../../../resources/lang', 'category');

        // Call pblish redources function
        $this->publishResources();

        include __DIR__ . '/../Http/routes.php';
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('category', function ($app) {
            return $this->app->make('Category\Category\Category');
        });

        // Bind Category to repository
        $this->app->bind(
            \Category\Category\Interfaces\CategoryRepositoryInterface::class,
            \Category\Category\Repositories\Eloquent\CategoryRepository::class
        );

        $this->app->register(\Category\Category\Providers\AuthServiceProvider::class);
        $this->app->register(\Category\Category\Providers\EventServiceProvider::class);
        $this->app->register(\Category\Category\Providers\RouteServiceProvider::class);
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['category'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../../../config/config.php' => config_path('package/category.php')], 'config');

        // Publish public view
        $this->publishes([__DIR__ . '/../../../../resources/views/public'  => base_path('resources/views/vendor/category/public')], 'view-public');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../../../resources/views/admin' => base_path('resources/views/vendor/category/admin')], 'view-admin');

        // Publish language files
        $this->publishes([__DIR__ . '/../../../../resources/lang' => base_path('resources/lang/vendor/category')], 'lang');

        // Publish migrations
        $this->publishes([__DIR__ . '/../../../../database/migrations/' => base_path('database/migrations')], 'migrations');

        // Publish seeds
        $this->publishes([__DIR__ . '/../../../../database/seeds/' => base_path('database/seeds')], 'seeds');
    }
}
