<?php

namespace Category\Category\Repositories\Eloquent;

use Category\Category\Interfaces\CategoryRepositoryInterface;
use Litepie\Database\Eloquent\BaseRepository;

class CategoryRepository extends BaseRepository implements CategoryRepositoryInterface
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'name'  => 'like'
    ];

    public function boot()
    {
        $this->pushCriteria(app('Litepie\Database\Criteria\RequestCriteria'));
    }

    /**
     * Specify Model class name.
     *
     * @return string
     */
    public function model()
    {
        return config('package.category.category.model');
    }
}
