<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'b2buy',

    /*
     * Package.
     */
    'package'   => 'contract',

    /*
     * Modules.
     */
    'modules'   => ['contract', 'bond'],

    'contract'       => [
        'model' => [
            'model' => \B2buy\Contract\Models\Contract::class,
            'repository' => \B2buy\Contract\Repositories\Eloquent\ContractRepository::class,
            'table' => 'contracts',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'createdat', 'updated_at'],
            'appends' => [],
            'fillable' => ['id',  'buyer_company_id',  'supplier_company_id',  'user_id',  'user_type',  'reference',  'contract_id',  'name',  'description',  'pricing_type',  'default_margin',  'add_all_products',  'standard_costprice',  'standard_margin',  'deleted_at',  'created_at',  'updated_at'],
            'translatables' => [],
            'upload_folder' => 'contract/contract',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider' => 'B2buy',
            'package' => 'Contract',
            'module' => 'Contract',
        ],
    ],
    'bond'       => [
        'model' => [
            'model' => \B2buy\Contract\Models\Bond::class,
            'repository' => \B2buy\Contract\Repositories\Eloquent\BondRepository::class,
            'table' => 'bonds',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'createdat', 'updated_at'],
            'appends' => [],
            'fillable' => ['id',  'contract_id',  'product_id',  'buyer_company_id',  'supplier_company_id',  'custom_price',  'pricing_type',  'contract_margin_type',  'slug',  'no_of_products',  'item_price',  'status',  'advantage_product',  'deadline',  'rfq_type',  'expiry',  'custom_margin',  'custom_cost_price',  'custom_blanket_margin',  'deleted_at',  'created_at',  'updated_at'],
            'translatables' => [],
            'upload_folder' => 'contract/bond',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider' => 'B2buy',
            'package' => 'Contract',
            'module' => 'Bond',
        ],
    ],
];
