<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateBondsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: bonds
         */
        Schema::create('bonds', function ($table) {
            $table->increments('id');
            $table->integer('contract_id')->nullable();
            $table->longText('product_id')->nullable();
            $table->integer('buyer_company_id')->nullable();
            $table->integer('supplier_company_id')->nullable();
            $table->text('custom_price')->nullable();
            $table->enum('pricing_type', ['Advantage','RFQ'])->nullable();
            $table->enum('contract_margin_type', ['All','Individual'])->nullable();
            $table->string('slug', 60)->nullable();
            $table->integer('no_of_products')->nullable();
            $table->double('item_price', 8,2)->nullable();
            $table->enum('status', ['Requested','Approved','Rejected','Expired','Declined'])->nullable();
            $table->integer('advantage_product')->nullable();
            $table->date('deadline')->nullable();
            $table->enum('rfq_type', ['0','1'])->nullable();
            $table->date('expiry')->nullable();
            $table->text('custom_margin')->nullable();
            $table->text('custom_cost_price')->nullable();
            $table->text('custom_blanket_margin')->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('bonds');
    }
}
