<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateContractsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: contracts
         */
        Schema::create('contracts', function ($table) {
            $table->increments('id');
            $table->integer('buyer_company_id')->nullable();
            $table->integer('supplier_company_id')->nullable();
            $table->integer('user_id')->nullable();
            $table->string('user_type', 100)->nullable();
            $table->string('reference', 15)->nullable();
            $table->string('contract_id', 15)->nullable();
            $table->text('name')->nullable();
            $table->longText('description')->nullable();
            $table->enum('pricing_type', ['Advantage'])->nullable();
            $table->double('default_margin', 50)->nullable();
            $table->integer('add_all_products')->nullable();
            $table->integer('standard_costprice')->nullable();
            $table->integer('standard_margin')->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('contracts');
    }
}
