# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/b2buy/contract/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {
         ...

        "classmap": [
            ...
            
            "packages/b2buy/contract/database/seeds",
            
            ...
        ],
        "psr-4": {
            ...
            
            "B2buy\\Contract\\": "packages/b2buy/contract/src",
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        B2buy\Contract\Providers\ContractServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Contract'  => B2buy\Contract\Facades\Contract::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=B2buy\\ContractTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="B2buy\Contract\Providers\ContractServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="B2buy\Contract\Providers\ContractServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="B2buy\Contract\Providers\ContractServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/contract/{modulename}

**User**

    http://path-to-route-folder/user/contract/{modulename}

**Public**

    http://path-to-route-folder/contracts


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/contract/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/contract/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/contract/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/contract/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/contract/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/contract/{modulename}/{slug}
    METHOD: GET