Lavalite package that provides contract management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `b2buy/contract`.

    "b2buy/contract": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    B2buy\Contract\Providers\ContractServiceProvider::class,

And also add it to alias

    'Contract'  => B2buy\Contract\Facades\Contract::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=B2buy\\Contract\\Seeds\\ContractTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="B2buy\Contract\Providers\ContractServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="B2buy\Contract\Providers\ContractServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="B2buy\Contract\Providers\ContractServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/contract/{modulename}

**User**

    http://path-to-route-folder/user/contract/{modulename}

**Public**

    http://path-to-route-folder/contracts


### API endpoints

**List**

    http://path-to-route-folder/api/user/contract/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/contract/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/contract/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/contract/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/contract/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/contract/{modulename}/{slug}
    METHOD: GET