<?php

// Web routes  for contract.

// Guard routes for contract
Route::prefix('{guard}/contract')->group(function () {
    Route::resource('contract', 'ContractResourceController');
});

// Guard routes for bond
Route::prefix('{guard}/contract')->group(function () {
    Route::resource('bond', 'BondResourceController');
});



// Public routes for contract
Route::get('contracts/', 'ContractPublicController@index');
Route::get('contract/{slug?}', 'ContractPublicController@show');


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for contract
            Route::prefix('{guard}/contract')->group(function () {
                Route::resource('contract', 'ContractResourceController');
            });
            
            // Guard routes for bond
            Route::prefix('{guard}/contract')->group(function () {
                Route::resource('bond', 'BondResourceController');
            });
            
            

            // Public routes for contract
            Route::get('contracts/', 'ContractPublicController@index');
            Route::get('contract/{slug?}', 'ContractPublicController@show');

        }
    );
}