<?php

namespace B2buy\Contract\Forms;

use Litepie\Form\FormInterpreter;

class Bond extends FormInterpreter
{

    /**
     * Sets the form and form elements.
     * @return null.
     */
    public static function setAttributes()
    {

        self::$urls = [
            'new' => [
                'url' => guard_url('contract/bond/new'),
                'method' => 'GET',
            ],
            'create' => [
                'url' => guard_url('contract/bond/create'),
                'method' => 'GET',
            ],
            'store' => [
                'url' => guard_url('contract/bond'),
                'method' => 'POST',
            ],
            'update' => [
                'url' => guard_url('contract/bond'),
                'method' => 'PUT',
            ],
            'list' => [
                'url' => guard_url('contract/bond'),
                'method' => 'GET',
            ],
            'delete' => [
                'url' => guard_url('contract/bond'),
                'method' => 'DELETE',
            ],
        ];
        self::$search = [
            'name' => [
                "type" => 'text',
                "label" => trans('contract::contract.label.name'),
                "placeholder" => trans('contract::contract.placeholder.name'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "4",
                "roles" => [],
            ]
        ];
        self::$orderBy = [
            'created_at' => trans('contract::contract.label.created_at'),
            'name' => trans('contract::contract.label.name'),
            'status' => trans('contract::contract.label.status'),
        ];
        self::$groups = [
            'main' => trans('contract::contract.groups.main'),
            'details' => trans('contract::contract.groups.details'),
            'images' => trans('contract::contract.groups.images'),
            'settings' => trans('contract::contract.groups.settings'),
        ];
        self::$list = [
            [
                'key' => "ref",
                'label' => trans('contract::contract.label.ref'),
                'sortable' => 'true',
                'roles' => [],
            ],
            [
                'key' => "id",
                'label' => trans('contract::contract.label.id'),
                'sortable' => 'true',
                'roles' => [],
            ],
            [
                'key' => "name",
                'label' => trans('contract::contract.label.name'),
                'sortable' => 'true',
                'roles' => [],
            ],
            [
                'key' => "status",
                'label' => trans('contract::contract.label.status'),
                'sortable' => 'true',
                'roles' => [],
            ],
        ];
        self::$fields = [
                'contract_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => trans('contract::bond.label.contract_id'),
                "placeholder" => trans('contract::bond.placeholder.contract_id'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'product_id' => [
                "element" => 'html_editor',
                "type" => 'html_editor',
                "label" => trans('contract::bond.label.product_id'),
                "placeholder" => trans('contract::bond.placeholder.product_id'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'buyer_company_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => trans('contract::bond.label.buyer_company_id'),
                "placeholder" => trans('contract::bond.placeholder.buyer_company_id'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'supplier_company_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => trans('contract::bond.label.supplier_company_id'),
                "placeholder" => trans('contract::bond.placeholder.supplier_company_id'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'custom_price' => [
                "element" => 'text',
                "type" => 'text',
                "label" => trans('contract::bond.label.custom_price'),
                "placeholder" => trans('contract::bond.placeholder.custom_price'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'pricing_type' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => trans('contract::bond.label.pricing_type'),
                "placeholder" => trans('contract::bond.placeholder.pricing_type'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'contract_margin_type' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => trans('contract::bond.label.contract_margin_type'),
                "placeholder" => trans('contract::bond.placeholder.contract_margin_type'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'no_of_products' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => trans('contract::bond.label.no_of_products'),
                "placeholder" => trans('contract::bond.placeholder.no_of_products'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'item_price' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => trans('contract::bond.label.item_price'),
                "placeholder" => trans('contract::bond.placeholder.item_price'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'advantage_product' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => trans('contract::bond.label.advantage_product'),
                "placeholder" => trans('contract::bond.placeholder.advantage_product'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'deadline' => [
                "element" => 'date_picker',
                "type" => 'date_picker',
                "label" => trans('contract::bond.label.deadline'),
                "placeholder" => trans('contract::bond.placeholder.deadline'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'rfq_type' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => trans('contract::bond.label.rfq_type'),
                "placeholder" => trans('contract::bond.placeholder.rfq_type'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'expiry' => [
                "element" => 'date_picker',
                "type" => 'date_picker',
                "label" => trans('contract::bond.label.expiry'),
                "placeholder" => trans('contract::bond.placeholder.expiry'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'custom_margin' => [
                "element" => 'text',
                "type" => 'text',
                "label" => trans('contract::bond.label.custom_margin'),
                "placeholder" => trans('contract::bond.placeholder.custom_margin'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'custom_cost_price' => [
                "element" => 'text',
                "type" => 'text',
                "label" => trans('contract::bond.label.custom_cost_price'),
                "placeholder" => trans('contract::bond.placeholder.custom_cost_price'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'custom_blanket_margin' => [
                "element" => 'text',
                "type" => 'text',
                "label" => trans('contract::bond.label.custom_blanket_margin'),
                "placeholder" => trans('contract::bond.placeholder.custom_blanket_margin'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ];

        return new static();
    }
}
