<?php

namespace B2buy\Contract\Forms;

use Litepie\Form\FormInterpreter;

class Contract extends FormInterpreter
{

    /**
     * Sets the form and form elements.
     * @return null.
     */
    public static function setAttributes()
    {

        self::$urls = [
            'new' => [
                'url' => guard_url('contract/contract/new'),
                'method' => 'GET',
            ],
            'create' => [
                'url' => guard_url('contract/contract/create'),
                'method' => 'GET',
            ],
            'store' => [
                'url' => guard_url('contract/contract'),
                'method' => 'POST',
            ],
            'update' => [
                'url' => guard_url('contract/contract'),
                'method' => 'PUT',
            ],
            'list' => [
                'url' => guard_url('contract/contract'),
                'method' => 'GET',
            ],
            'delete' => [
                'url' => guard_url('contract/contract'),
                'method' => 'DELETE',
            ],
        ];
        self::$search = [
            'name' => [
                "type" => 'text',
                "label" => trans('contract::contract.label.name'),
                "placeholder" => trans('contract::contract.placeholder.name'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "4",
                "roles" => [],
            ]
        ];
        self::$orderBy = [
            'created_at' => trans('contract::contract.label.created_at'),
            'name' => trans('contract::contract.label.name'),
            'status' => trans('contract::contract.label.status'),
        ];
        self::$groups = [
            'main' => trans('contract::contract.groups.main'),
            'details' => trans('contract::contract.groups.details'),
            'images' => trans('contract::contract.groups.images'),
            'settings' => trans('contract::contract.groups.settings'),
        ];
        self::$list = [
            [
                'key' => "ref",
                'label' => trans('contract::contract.label.ref'),
                'sortable' => 'true',
                'roles' => [],
            ],
            [
                'key' => "id",
                'label' => trans('contract::contract.label.id'),
                'sortable' => 'true',
                'roles' => [],
            ],
            [
                'key' => "name",
                'label' => trans('contract::contract.label.name'),
                'sortable' => 'true',
                'roles' => [],
            ],
            [
                'key' => "status",
                'label' => trans('contract::contract.label.status'),
                'sortable' => 'true',
                'roles' => [],
            ],
        ];
        self::$fields = [
                'buyer_company_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => trans('contract::contract.label.buyer_company_id'),
                "placeholder" => trans('contract::contract.placeholder.buyer_company_id'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'supplier_company_id' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => trans('contract::contract.label.supplier_company_id'),
                "placeholder" => trans('contract::contract.placeholder.supplier_company_id'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'reference' => [
                "element" => 'text',
                "type" => 'text',
                "label" => trans('contract::contract.label.reference'),
                "placeholder" => trans('contract::contract.placeholder.reference'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'contract_id' => [
                "element" => 'text',
                "type" => 'text',
                "label" => trans('contract::contract.label.contract_id'),
                "placeholder" => trans('contract::contract.placeholder.contract_id'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'name' => [
                "element" => 'text',
                "type" => 'text',
                "label" => trans('contract::contract.label.name'),
                "placeholder" => trans('contract::contract.placeholder.name'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'description' => [
                "element" => 'html_editor',
                "type" => 'html_editor',
                "label" => trans('contract::contract.label.description'),
                "placeholder" => trans('contract::contract.placeholder.description'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'pricing_type' => [
                "element" => 'radios',
                "type" => 'radios',
                "label" => trans('contract::contract.label.pricing_type'),
                "placeholder" => trans('contract::contract.placeholder.pricing_type'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'default_margin' => [
                "element" => 'decimal',
                "type" => 'decimal',
                "label" => trans('contract::contract.label.default_margin'),
                "placeholder" => trans('contract::contract.placeholder.default_margin'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'add_all_products' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => trans('contract::contract.label.add_all_products'),
                "placeholder" => trans('contract::contract.placeholder.add_all_products'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'standard_costprice' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => trans('contract::contract.label.standard_costprice'),
                "placeholder" => trans('contract::contract.placeholder.standard_costprice'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'standard_margin' => [
                "element" => 'numeric',
                "type" => 'numeric',
                "label" => trans('contract::contract.label.standard_margin'),
                "placeholder" => trans('contract::contract.placeholder.standard_margin'),
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ];

        return new static();
    }
}
