<?php

namespace B2buy\Contract\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;
use B2buy\Contract\Models\Bond;

class BondPolicy
{

    /**
     * Determine if the given user can view the bond.
     *
     * @param UserPolicyInterface $authUser
     * @param Bond $bond
     *
     * @return bool
     */
    public function view(UserPolicyInterface $authUser, Bond $bond)
    {
        if ($authUser->canDo('contract.bond.view') && $authUser->isAdmin()) {
            return true;
        }

        return $bond->user_id == user_id() && $bond->user_type == user_type();
    }

    /**
     * Determine if the given user can create a bond.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function create(UserPolicyInterface $authUser)
    {
        return  $authUser->canDo('contract.bond.create');
    }

    /**
     * Determine if the given user can update the given bond.
     *
     * @param UserPolicyInterface $authUser
     * @param Bond $bond
     *
     * @return bool
     */
    public function update(UserPolicyInterface $authUser, Bond $bond)
    {
        if ($authUser->canDo('contract.bond.edit') && $authUser->isAdmin()) {
            return true;
        }

        return $bond->user_id == user_id() && $bond->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given bond.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function destroy(UserPolicyInterface $authUser, Bond $bond)
    {
        return $bond->user_id == user_id() && $bond->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given bond.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function verify(UserPolicyInterface $authUser, Bond $bond)
    {
        if ($authUser->canDo('contract.bond.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given bond.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function approve(UserPolicyInterface $authUser, Bond $bond)
    {
        if ($authUser->canDo('contract.bond.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $authUser    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($authUser, $ability)
    {
        if ($authUser->isSuperuser()) {
            return true;
        }
    }
}
