<?php

namespace B2buy\Contract\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;
use B2buy\Contract\Models\Contract;

class ContractPolicy
{

    /**
     * Determine if the given user can view the contract.
     *
     * @param UserPolicyInterface $authUser
     * @param Contract $contract
     *
     * @return bool
     */
    public function view(UserPolicyInterface $authUser, Contract $contract)
    {
        if ($authUser->canDo('contract.contract.view') && $authUser->isAdmin()) {
            return true;
        }

        return $contract->user_id == user_id() && $contract->user_type == user_type();
    }

    /**
     * Determine if the given user can create a contract.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function create(UserPolicyInterface $authUser)
    {
        return  $authUser->canDo('contract.contract.create');
    }

    /**
     * Determine if the given user can update the given contract.
     *
     * @param UserPolicyInterface $authUser
     * @param Contract $contract
     *
     * @return bool
     */
    public function update(UserPolicyInterface $authUser, Contract $contract)
    {
        if ($authUser->canDo('contract.contract.edit') && $authUser->isAdmin()) {
            return true;
        }

        return $contract->user_id == user_id() && $contract->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given contract.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function destroy(UserPolicyInterface $authUser, Contract $contract)
    {
        return $contract->user_id == user_id() && $contract->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given contract.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function verify(UserPolicyInterface $authUser, Contract $contract)
    {
        if ($authUser->canDo('contract.contract.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given contract.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function approve(UserPolicyInterface $authUser, Contract $contract)
    {
        if ($authUser->canDo('contract.contract.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $authUser    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($authUser, $ability)
    {
        if ($authUser->isSuperuser()) {
            return true;
        }
    }
}
