<?php

namespace B2buy\Contract\Providers;

use Illuminate\Contracts\Auth\Access\Gate as GateContract;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the package.
     *
     * @var array
     */
    protected $policies = [
        // Bind Contract policy
        \B2buy\Contract\Repositories\Eloquent\ContractRepository::class 
        => \B2buy\Contract\Policies\ContractPolicy::class,// Bind Bond policy
        \B2buy\Contract\Repositories\Eloquent\BondRepository::class 
        => \B2buy\Contract\Policies\BondPolicy::class,
    ];

    /**
     * Register any package authentication / authorization services.
     *
     * @param \Illuminate\Contracts\Auth\Access\Gate $gate
     *
     * @return void
     */
    public function boot(GateContract $gate)
    {
        parent::registerPolicies($gate);
    }
}
