<?php

namespace B2buy\Contract\Repositories\Eloquent;

use B2buy\Contract\Interfaces\BondRepositoryInterface;
use Litepie\Repository\BaseRepository;
use B2buy\Contract\Repositories\Eloquent\Presenters\BondItemPresenter;


class BondRepository extends BaseRepository implements BondRepositoryInterface
{

    public function boot()
    {
        $this->fieldSearchable = config('b2buy.contract.bond.model.search');
    }

    /**
     * Specify Model class name.
     *
     * @return string
     */
    public function model()
    {
        return config('b2buy.contract.bond.model.model');
    }

    /**
     * Returns the default presenter if none is availabale.
     *
     * @return void
     */
    public function presenter()
    {
        return BondItemPresenter::class;
    }
}
