<?php

namespace B2buy\Contract\Repositories\Eloquent;

use B2buy\Contract\Interfaces\ContractRepositoryInterface;
use Litepie\Repository\BaseRepository;
use B2buy\Contract\Repositories\Eloquent\Presenters\ContractItemPresenter;


class ContractRepository extends BaseRepository implements ContractRepositoryInterface
{

    public function boot()
    {
        $this->fieldSearchable = config('b2buy.contract.contract.model.search');
    }

    /**
     * Specify Model class name.
     *
     * @return string
     */
    public function model()
    {
        return config('b2buy.contract.contract.model.model');
    }

    /**
     * Returns the default presenter if none is availabale.
     *
     * @return void
     */
    public function presenter()
    {
        return ContractItemPresenter::class;
    }
}
