<?php

namespace B2buy\Contract\Repositories\Eloquent\Presenters;

use Litepie\Repository\Presenter\Presenter;

class BondItemPresenter extends Presenter
{

    public function itemLink()
    {
        return guard_url('contract/bond') . '/' . $this->getRouteKey();
    }

    public function title()
    {
        if ($this->title != '') {
            return $this->title;
        }

        if ($this->name != '') {
            return $this->name;
        }

        return 'None';
    }

    public function toArray()
    {
        return [
            'id' => $this->getRouteKey(),
            'title' => $this->title(),
            'contract_id' => $this->contract_id,
            'product_id' => $this->product_id,
            'buyer_company_id' => $this->buyer_company_id,
            'supplier_company_id' => $this->supplier_company_id,
            'custom_price' => $this->custom_price,
            'pricing_type' => $this->pricing_type,
            'contract_margin_type' => $this->contract_margin_type,
            'slug' => $this->slug,
            'no_of_products' => $this->no_of_products,
            'item_price' => $this->item_price,
            'status' => $this->status,
            'advantage_product' => $this->advantage_product,
            'deadline' => $this->deadline,
            'rfq_type' => $this->rfq_type,
            'expiry' => $this->expiry,
            'custom_margin' => $this->custom_margin,
            'custom_cost_price' => $this->custom_cost_price,
            'custom_blanket_margin' => $this->custom_blanket_margin,
            'created_at' => !is_null($this->created_at) ? $this->created_at->format('Y-m-d H:i:s') : null,
            'updated_at' => !is_null($this->updated_at) ? $this->updated_at->format('Y-m-d H:i:s') : null,
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
            ],
        ];
    }
}
