<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateCallsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: calls
         */
        Schema::create('calls', function ($table) {
            $table->increments('id');
            $table->string('ref', 100)->nullable();
            $table->integer('owner_id')->nullable();
            $table->date('assigned_at')->nullable();
            $table->integer('agent_id')->nullable();
            $table->date('contacted_at')->nullable();
            $table->integer('category_id')->nullable();
            $table->integer('city_id')->nullable();
            $table->integer('location_id')->nullable();
            $table->integer('sublocation_id')->nullable();
            $table->integer('property_id')->nullable();
            $table->string('building_no', 200)->nullable();
            $table->string('customer_type', 100)->nullable();
            $table->string('status', 15)->nullable();
            $table->string('color', 50)->nullable();
            $table->string('unit', 100)->nullable();
            $table->string('plot', 100)->nullable();
            $table->string('name', 100)->nullable();
            $table->string('mobile', 100)->nullable();
            $table->string('phone', 50)->nullable();
            $table->string('email', 100)->nullable();
            $table->text('notes')->nullable();
            $table->integer('created_by')->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('calls');
    }
}
