<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateDatabasesTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: databases
         */
        Schema::create('databases', function ($table) {
            $table->increments('id');
            $table->string('ref', 100)->nullable();
            $table->integer('upload_id')->nullable();
            $table->date('contacted_at')->nullable();
            $table->integer('contacted_by')->nullable();
            $table->string('contacted_status', 15)->nullable();
            $table->integer('city_id')->nullable();
            $table->integer('location_id')->nullable();
            $table->integer('sublocation_id')->nullable();
            $table->integer('property_id')->nullable();
            $table->string('building_no', 200)->nullable();
            $table->integer('bua')->nullable();
            $table->string('unit', 100)->nullable();
            $table->string('plot', 100)->nullable();
            $table->string('name', 100)->nullable();
            $table->string('mobile', 100)->nullable();
            $table->string('phone', 50)->nullable();
            $table->string('email', 100)->nullable();
            $table->integer('created_by')->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('databases');
    }
}
