<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateUploadsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: uploads
         */
        Schema::create('uploads', function ($table) {
            $table->increments('id');
            $table->integer('city_id')->nullable();
            $table->integer('location_id')->nullable();
            $table->integer('sublocation_id')->nullable();
            $table->integer('property_id')->nullable();
            $table->string('building_no', 200)->nullable();
            $table->string('plot', 100)->nullable();
            $table->text('file')->nullable();
            $table->string('slug', 100)->nullable();
            $table->integer('user_id')->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('uploads');
    }
}
