<?php

namespace Bixo\Database;

use DB;
use Illuminate\Database\Seeder;

class CallTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('calls')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'database.call.view',
                'name'      => 'View Call',
            ],
            [
                'slug'      => 'database.call.create',
                'name'      => 'Create Call',
            ],
            [
                'slug'      => 'database.call.edit',
                'name'      => 'Update Call',
            ],
            [
                'slug'      => 'database.call.delete',
                'name'      => 'Delete Call',
            ],
            
            // Customize this permissions if needed.
            [
                'slug'      => 'database.call.verify',
                'name'      => 'Verify Call',
            ],
            [
                'slug'      => 'database.call.approve',
                'name'      => 'Approve Call',
            ],
            [
                'slug'      => 'database.call.publish',
                'name'      => 'Publish Call',
            ],
            [
                'slug'      => 'database.call.unpublish',
                'name'      => 'Unpublish Call',
            ],
            [
                'slug'      => 'database.call.cancel',
                'name'      => 'Cancel Call',
            ],
            [
                'slug'      => 'database.call.archive',
                'name'      => 'Archive Call',
            ],
            
        ]);

        DB::table('menus')->insert([

            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/database/call',
                'name'        => 'Call',
                'description' => null,
                'icon'        => 'fa fa-newspaper-o',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/database/call',
                'name'        => 'Call',
                'description' => null,
                'icon'        => 'icon-book-open',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'call',
                'name'        => 'Call',
                'description' => null,
                'icon'        => null,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Database',
                'module'    => 'Call',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'database.call.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
