<?php

namespace Bixo\Database;

use DB;
use Illuminate\Database\Seeder;

class DatabaseTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('databases')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'database.database.view',
                'name'      => 'View Database',
            ],
            [
                'slug'      => 'database.database.create',
                'name'      => 'Create Database',
            ],
            [
                'slug'      => 'database.database.edit',
                'name'      => 'Update Database',
            ],
            [
                'slug'      => 'database.database.delete',
                'name'      => 'Delete Database',
            ],
            
            // Customize this permissions if needed.
            [
                'slug'      => 'database.database.verify',
                'name'      => 'Verify Database',
            ],
            [
                'slug'      => 'database.database.approve',
                'name'      => 'Approve Database',
            ],
            [
                'slug'      => 'database.database.publish',
                'name'      => 'Publish Database',
            ],
            [
                'slug'      => 'database.database.unpublish',
                'name'      => 'Unpublish Database',
            ],
            [
                'slug'      => 'database.database.cancel',
                'name'      => 'Cancel Database',
            ],
            [
                'slug'      => 'database.database.archive',
                'name'      => 'Archive Database',
            ],
            
        ]);

        DB::table('menus')->insert([

            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/database/database',
                'name'        => 'Database',
                'description' => null,
                'icon'        => 'fa fa-newspaper-o',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/database/database',
                'name'        => 'Database',
                'description' => null,
                'icon'        => 'icon-book-open',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'database',
                'name'        => 'Database',
                'description' => null,
                'icon'        => null,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Database',
                'module'    => 'Database',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'database.database.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
