<?php

namespace Bixo\Database;

use DB;
use Illuminate\Database\Seeder;

class UploadTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('uploads')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'database.upload.view',
                'name'      => 'View Upload',
            ],
            [
                'slug'      => 'database.upload.create',
                'name'      => 'Create Upload',
            ],
            [
                'slug'      => 'database.upload.edit',
                'name'      => 'Update Upload',
            ],
            [
                'slug'      => 'database.upload.delete',
                'name'      => 'Delete Upload',
            ],
            
            // Customize this permissions if needed.
            [
                'slug'      => 'database.upload.verify',
                'name'      => 'Verify Upload',
            ],
            [
                'slug'      => 'database.upload.approve',
                'name'      => 'Approve Upload',
            ],
            [
                'slug'      => 'database.upload.publish',
                'name'      => 'Publish Upload',
            ],
            [
                'slug'      => 'database.upload.unpublish',
                'name'      => 'Unpublish Upload',
            ],
            [
                'slug'      => 'database.upload.cancel',
                'name'      => 'Cancel Upload',
            ],
            [
                'slug'      => 'database.upload.archive',
                'name'      => 'Archive Upload',
            ],
            
        ]);

        DB::table('menus')->insert([

            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/database/upload',
                'name'        => 'Upload',
                'description' => null,
                'icon'        => 'fa fa-newspaper-o',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/database/upload',
                'name'        => 'Upload',
                'description' => null,
                'icon'        => 'icon-book-open',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'upload',
                'name'        => 'Upload',
                'description' => null,
                'icon'        => null,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Database',
                'module'    => 'Upload',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'database.upload.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
