# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/bixo/database/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {
         ...

        "classmap": [
            ...
            
            "packages/bixo/database/database/seeds",
            
            ...
        ],
        "psr-4": {
            ...
            
            "Bixo\\Database\\": "packages/bixo/database/src",
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Bixo\Database\Providers\DatabaseServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Database'  => Bixo\Database\Facades\Database::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Bixo\\DatabaseTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Bixo\Database\Providers\DatabaseServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Bixo\Database\Providers\DatabaseServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Bixo\Database\Providers\DatabaseServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/database/{modulename}

**User**

    http://path-to-route-folder/user/database/{modulename}

**Public**

    http://path-to-route-folder/databases


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/database/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/database/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/database/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/database/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/database/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/database/{modulename}/{slug}
    METHOD: GET