Lavalite package that provides database management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `bixo/database`.

    "bixo/database": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Bixo\Database\Providers\DatabaseServiceProvider::class,

And also add it to alias

    'Database'  => Bixo\Database\Facades\Database::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Bixo\\DatabaseTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Bixo\Database\Providers\DatabaseServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Bixo\Database\Providers\DatabaseServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Bixo\Database\Providers\DatabaseServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/database/{modulename}

**User**

    http://path-to-route-folder/user/database/{modulename}

**Public**

    http://path-to-route-folder/databases


### API endpoints

**List**

    http://path-to-route-folder/api/user/database/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/database/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/database/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/database/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/database/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/database/{modulename}/{slug}
    METHOD: GET