<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-file-text-o"></i> {!! trans('database::call.name') !!} <small> {!! trans('app.manage') !!} {!! trans('database::call.names') !!}</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{!! guard_url('/') !!}"><i class="fa fa-dashboard"></i> {!! trans('app.home') !!} </a></li>
            <li class="active">{!! trans('database::call.names') !!}</li>
        </ol>
    </section>
    <!-- Main content -->
    <section class="content">
    <div id='database-call-entry'>
    </div>
        <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
                    <li class="{!!(request('status') == '')?'active':'';!!}"><a href="{!!guard_url('database/call')!!}">{!! trans('database::call.names') !!}</a></li>
                    <li class="{!!(request('status') == 'archive')?'active':'';!!}"><a href="{!!guard_url('database/call?status=archive')!!}">Archived</a></li>
                    <li class="{!!(request('status') == 'deleted')?'active':'';!!}"><a href="{!!guard_url('database/call?status=deleted')!!}">Trashed</a></li>
                    <li class="pull-right">
                    <span class="actions">
                    <!--   
                    <a  class="btn btn-xs btn-purple"  href="{!!guard_url('database/call/reports')!!}"><i class="fa fa-bar-chart" aria-hidden="true"></i><span class="hidden-sm hidden-xs"> Reports</span></a>
                    @include('database::admin.call.partial.actions')
                    -->
                    @include('database::admin.call.partial.filter')
                    @include('database::admin.call.partial.column')
                    </span> 
                </li>
            </ul>
            <div class="tab-content">
                <table id="database-call-list" class="table table-striped data-table">
                    <thead class="list_head">
                        <th style="text-align: right;" width="1%"><a class="btn-reset-filter" href="#Reset" style="display:none; color:#fff;"><i class="fa fa-filter"></i></a> <input type="checkbox" id="database-call-check-all"></th>
                        <th data-field="ref">{!! trans('database::call.label.ref')!!}</th>
                    <th data-field="owner_id">{!! trans('database::call.label.owner_id')!!}</th>
                    <th data-field="assigned_at">{!! trans('database::call.label.assigned_at')!!}</th>
                    <th data-field="agent_id">{!! trans('database::call.label.agent_id')!!}</th>
                    <th data-field="contacted_at">{!! trans('database::call.label.contacted_at')!!}</th>
                    <th data-field="category_id">{!! trans('database::call.label.category_id')!!}</th>
                    <th data-field="city_id">{!! trans('database::call.label.city_id')!!}</th>
                    <th data-field="location_id">{!! trans('database::call.label.location_id')!!}</th>
                    <th data-field="sublocation_id">{!! trans('database::call.label.sublocation_id')!!}</th>
                    <th data-field="property_id">{!! trans('database::call.label.property_id')!!}</th>
                    <th data-field="building_no">{!! trans('database::call.label.building_no')!!}</th>
                    <th data-field="customer_type">{!! trans('database::call.label.customer_type')!!}</th>
                    <th data-field="color">{!! trans('database::call.label.color')!!}</th>
                    <th data-field="unit">{!! trans('database::call.label.unit')!!}</th>
                    <th data-field="plot">{!! trans('database::call.label.plot')!!}</th>
                    <th data-field="name">{!! trans('database::call.label.name')!!}</th>
                    <th data-field="mobile">{!! trans('database::call.label.mobile')!!}</th>
                    <th data-field="phone">{!! trans('database::call.label.phone')!!}</th>
                    <th data-field="email">{!! trans('database::call.label.email')!!}</th>
                    <th data-field="notes">{!! trans('database::call.label.notes')!!}</th>
                    <th data-field="created_by">{!! trans('database::call.label.created_by')!!}</th>
                    </thead>
                </table>
            </div>
        </div>
    </section>
</div>

<script type="text/javascript">

var oTable;
var oSearch;
$(document).ready(function(){
    app.load('#database-call-entry', '{!!guard_url('database/call/0')!!}');
    oTable = $('#database-call-list').dataTable( {
        'columnDefs': [{
            'targets': 0,
            'searchable': false,
            'orderable': false,
            'className': 'dt-body-center',
            'render': function (data, type, full, meta){
                return '<input type="checkbox" name="id[]" value="' + data.id + '">';
            }
        }], 
        
        "responsive" : true,
        "order": [[1, 'asc']],
        "bProcessing": true,
        "sDom": 'R<>rt<ilp><"clear">',
        "bServerSide": true,
        "sAjaxSource": '{!! guard_url('database/call') !!}',
        "fnServerData" : function ( sSource, aoData, fnCallback ) {

            $.each(oSearch, function(key, val){
                aoData.push( { 'name' : key, 'value' : val } );
            });
            app.dataTable(aoData);
            $.ajax({
                'dataType'  : 'json',
                'data'      : aoData,
                'type'      : 'GET',
                'url'       : sSource,
                'success'   : fnCallback
            });
        },

        "columns": [
            {data :'id'},
            {data :'ref'},
            {data :'owner_id'},
            {data :'assigned_at'},
            {data :'agent_id'},
            {data :'contacted_at'},
            {data :'category_id'},
            {data :'city_id'},
            {data :'location_id'},
            {data :'sublocation_id'},
            {data :'property_id'},
            {data :'building_no'},
            {data :'customer_type'},
            {data :'color'},
            {data :'unit'},
            {data :'plot'},
            {data :'name'},
            {data :'mobile'},
            {data :'phone'},
            {data :'email'},
            {data :'notes'},
            {data :'created_by'},
        ],
        "pageLength": 25
    });

    $('#database-call-list tbody').on( 'click', 'tr', function () {
        oTable.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        var d = $('#database-call-list').DataTable().row( this ).data();
        $('#database-call-entry').load('{!!guard_url('database/call')!!}' + '/' + d.id);
    });

    $('#database-call-list tbody').on( 'change', "input[name^='id[]']", function (e) {
        e.preventDefault();

        aIds = [];
        $(".child").remove();
        $(this).parent().parent().removeClass('parent'); 
        $("input[name^='id[]']:checked").each(function(){
            aIds.push($(this).val());
        });
    });

    $("#database-call-check-all").on( 'change', function (e) {
        e.preventDefault();
        aIds = [];
        if ($(this).prop('checked')) {
            $("input[name^='id[]']").each(function(){
                $(this).prop('checked',true);
                aIds.push($(this).val());
            });

            return;
        }else{
            $("input[name^='id[]']").prop('checked',false);
        }
        
    });


    $(".reset_filter").click(function (e) {
        e.preventDefault();
        $("#form-search")[ 0 ].reset();
        $('#form-search input,#form-search select').each( function () {
          oTable.search( this.value ).draw();
        });
        $('#database-call-list .reset_filter').css('display', 'none');

    });


    // Add event listener for opening and closing details
    $('#database-call-list tbody').on('click', 'td.details-control', function (e) {
        e.preventDefault();
        var tr = $(this).closest('tr');
        var row = table.row( tr );
 
        if ( row.child.isShown() ) {
            // This row is already open - close it
            row.child.hide();
            tr.removeClass('shown');
        } else {
            // Open this row
            row.child( format(row.data()) ).show();
            tr.addClass('shown');
        }
    });

});
</script>