<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-file-text-o"></i> {!! trans('database::database.name') !!} <small> {!! trans('app.manage') !!} {!! trans('database::database.names') !!}</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="{!! guard_url('/') !!}"><i class="fa fa-dashboard"></i> {!! trans('app.home') !!} </a></li>
            <li class="active">{!! trans('database::database.names') !!}</li>
        </ol>
    </section>
    <!-- Main content -->
    <section class="content">
    <div id='database-database-entry'>
    </div>
        <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
                    <li class="{!!(request('status') == '')?'active':'';!!}"><a href="{!!guard_url('database/database')!!}">{!! trans('database::database.names') !!}</a></li>
                    <li class="{!!(request('status') == 'archive')?'active':'';!!}"><a href="{!!guard_url('database/database?status=archive')!!}">Archived</a></li>
                    <li class="{!!(request('status') == 'deleted')?'active':'';!!}"><a href="{!!guard_url('database/database?status=deleted')!!}">Trashed</a></li>
                    <li class="pull-right">
                    <span class="actions">
                    <!--   
                    <a  class="btn btn-xs btn-purple"  href="{!!guard_url('database/database/reports')!!}"><i class="fa fa-bar-chart" aria-hidden="true"></i><span class="hidden-sm hidden-xs"> Reports</span></a>
                    @include('database::admin.database.partial.actions')
                    -->
                    @include('database::admin.database.partial.filter')
                    @include('database::admin.database.partial.column')
                    </span> 
                </li>
            </ul>
            <div class="tab-content">
                <table id="database-database-list" class="table table-striped data-table">
                    <thead class="list_head">
                        <th style="text-align: right;" width="1%"><a class="btn-reset-filter" href="#Reset" style="display:none; color:#fff;"><i class="fa fa-filter"></i></a> <input type="checkbox" id="database-database-check-all"></th>
                        <th data-field="ref">{!! trans('database::database.label.ref')!!}</th>
                    <th data-field="upload_id">{!! trans('database::database.label.upload_id')!!}</th>
                    <th data-field="contacted_at">{!! trans('database::database.label.contacted_at')!!}</th>
                    <th data-field="contacted_by">{!! trans('database::database.label.contacted_by')!!}</th>
                    <th data-field="contacted_status">{!! trans('database::database.label.contacted_status')!!}</th>
                    <th data-field="city_id">{!! trans('database::database.label.city_id')!!}</th>
                    <th data-field="location_id">{!! trans('database::database.label.location_id')!!}</th>
                    <th data-field="sublocation_id">{!! trans('database::database.label.sublocation_id')!!}</th>
                    <th data-field="property_id">{!! trans('database::database.label.property_id')!!}</th>
                    <th data-field="building_no">{!! trans('database::database.label.building_no')!!}</th>
                    <th data-field="bua">{!! trans('database::database.label.bua')!!}</th>
                    <th data-field="unit">{!! trans('database::database.label.unit')!!}</th>
                    <th data-field="plot">{!! trans('database::database.label.plot')!!}</th>
                    <th data-field="name">{!! trans('database::database.label.name')!!}</th>
                    <th data-field="mobile">{!! trans('database::database.label.mobile')!!}</th>
                    <th data-field="phone">{!! trans('database::database.label.phone')!!}</th>
                    <th data-field="email">{!! trans('database::database.label.email')!!}</th>
                    <th data-field="created_by">{!! trans('database::database.label.created_by')!!}</th>
                    </thead>
                </table>
            </div>
        </div>
    </section>
</div>

<script type="text/javascript">

var oTable;
var oSearch;
$(document).ready(function(){
    app.load('#database-database-entry', '{!!guard_url('database/database/0')!!}');
    oTable = $('#database-database-list').dataTable( {
        'columnDefs': [{
            'targets': 0,
            'searchable': false,
            'orderable': false,
            'className': 'dt-body-center',
            'render': function (data, type, full, meta){
                return '<input type="checkbox" name="id[]" value="' + data.id + '">';
            }
        }], 
        
        "responsive" : true,
        "order": [[1, 'asc']],
        "bProcessing": true,
        "sDom": 'R<>rt<ilp><"clear">',
        "bServerSide": true,
        "sAjaxSource": '{!! guard_url('database/database') !!}',
        "fnServerData" : function ( sSource, aoData, fnCallback ) {

            $.each(oSearch, function(key, val){
                aoData.push( { 'name' : key, 'value' : val } );
            });
            app.dataTable(aoData);
            $.ajax({
                'dataType'  : 'json',
                'data'      : aoData,
                'type'      : 'GET',
                'url'       : sSource,
                'success'   : fnCallback
            });
        },

        "columns": [
            {data :'id'},
            {data :'ref'},
            {data :'upload_id'},
            {data :'contacted_at'},
            {data :'contacted_by'},
            {data :'contacted_status'},
            {data :'city_id'},
            {data :'location_id'},
            {data :'sublocation_id'},
            {data :'property_id'},
            {data :'building_no'},
            {data :'bua'},
            {data :'unit'},
            {data :'plot'},
            {data :'name'},
            {data :'mobile'},
            {data :'phone'},
            {data :'email'},
            {data :'created_by'},
        ],
        "pageLength": 25
    });

    $('#database-database-list tbody').on( 'click', 'tr', function () {
        oTable.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
        var d = $('#database-database-list').DataTable().row( this ).data();
        $('#database-database-entry').load('{!!guard_url('database/database')!!}' + '/' + d.id);
    });

    $('#database-database-list tbody').on( 'change', "input[name^='id[]']", function (e) {
        e.preventDefault();

        aIds = [];
        $(".child").remove();
        $(this).parent().parent().removeClass('parent'); 
        $("input[name^='id[]']:checked").each(function(){
            aIds.push($(this).val());
        });
    });

    $("#database-database-check-all").on( 'change', function (e) {
        e.preventDefault();
        aIds = [];
        if ($(this).prop('checked')) {
            $("input[name^='id[]']").each(function(){
                $(this).prop('checked',true);
                aIds.push($(this).val());
            });

            return;
        }else{
            $("input[name^='id[]']").prop('checked',false);
        }
        
    });


    $(".reset_filter").click(function (e) {
        e.preventDefault();
        $("#form-search")[ 0 ].reset();
        $('#form-search input,#form-search select').each( function () {
          oTable.search( this.value ).draw();
        });
        $('#database-database-list .reset_filter').css('display', 'none');

    });


    // Add event listener for opening and closing details
    $('#database-database-list tbody').on('click', 'td.details-control', function (e) {
        e.preventDefault();
        var tr = $(this).closest('tr');
        var row = table.row( tr );
 
        if ( row.child.isShown() ) {
            // This row is already open - close it
            row.child.hide();
            tr.removeClass('shown');
        } else {
            // Open this row
            row.child( format(row.data()) ).show();
            tr.addClass('shown');
        }
    });

});
</script>