<?php

// API routes  for call
Route::prefix('{guard}/database')->group(function () {
    Route::get('call/form/{element}', 'CallAPIController@form');
    Route::resource('call', 'CallAPIController');
});


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for databases
            Route::prefix('{guard}/database')->group(function () {
                Route::get('call/form/{element}', 'CallAPIController@form');
                Route::apiResource('call', 'CallAPIController');
            });
            // Public routes for databases
            Route::get('database/Call', 'CallPublicController@getCall');
        }
    );
}

// API routes  for database
Route::prefix('{guard}/database')->group(function () {
    Route::get('database/form/{element}', 'DatabaseAPIController@form');
    Route::resource('database', 'DatabaseAPIController');
});


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for databases
            Route::prefix('{guard}/database')->group(function () {
                Route::get('database/form/{element}', 'DatabaseAPIController@form');
                Route::apiResource('database', 'DatabaseAPIController');
            });
            // Public routes for databases
            Route::get('database/Database', 'DatabasePublicController@getDatabase');
        }
    );
}

// API routes  for upload
Route::prefix('{guard}/database')->group(function () {
    Route::get('upload/form/{element}', 'UploadAPIController@form');
    Route::resource('upload', 'UploadAPIController');
});


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for databases
            Route::prefix('{guard}/database')->group(function () {
                Route::get('upload/form/{element}', 'UploadAPIController@form');
                Route::apiResource('upload', 'UploadAPIController');
            });
            // Public routes for databases
            Route::get('database/Upload', 'UploadPublicController@getUpload');
        }
    );
}

