<?php

// web routes  for call
Route::prefix('{guard}/database')->group(function () {
    Route::resource('call', 'CallResourceController');
});


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for pages
            Route::prefix('{guard}/page')->group(function () {
                Route::apiResource('page', 'CallResourceController');
            });
            // Public routes for pages
            Route::get('databases/', 'CallPublicController@index');
            Route::get('databases/{slug?}', 'CallPublicController@show');
        }
    );
}

// web routes  for database
Route::prefix('{guard}/database')->group(function () {
    Route::resource('database', 'DatabaseResourceController');
});


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for pages
            Route::prefix('{guard}/page')->group(function () {
                Route::apiResource('page', 'DatabaseResourceController');
            });
            // Public routes for pages
            Route::get('databases/', 'DatabasePublicController@index');
            Route::get('databases/{slug?}', 'DatabasePublicController@show');
        }
    );
}

// web routes  for upload
Route::prefix('{guard}/database')->group(function () {
    Route::resource('upload', 'UploadResourceController');
});


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for pages
            Route::prefix('{guard}/page')->group(function () {
                Route::apiResource('page', 'UploadResourceController');
            });
            // Public routes for pages
            Route::get('databases/', 'UploadPublicController@index');
            Route::get('databases/{slug?}', 'UploadPublicController@show');
        }
    );
}

