<?php

namespace Bixo\Database;

use User;

class Database
{
    /**
     * $database object.
     */
    protected $database;    /**
     * $upload object.
     */
    protected $upload;

    /**
     * Constructor.
     */
    public function __construct(\Bixo\Database\Interfaces\DatabaseRepositoryInterface $database,        \Bixo\Database\Interfaces\UploadRepositoryInterface $upload)
    {
        $this->database = $database;        $this->upload = $upload;
    }

    /**
     * Returns count of database.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.database.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->database->pushCriteria(new \Litepie\Bixo\Repositories\Criteria\DatabaseUserCriteria());
        }

        $database = $this->database->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('database::' . $view, compact('database'))->render();
    }    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.upload.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->upload->pushCriteria(new \Litepie\Bixo\Repositories\Criteria\UploadUserCriteria());
        }

        $upload = $this->upload->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('database::' . $view, compact('upload'))->render();
    }
}
