<?php

namespace Bixo\Database\Forms;

class Call
{
    /**
     * Variable to store form configuration.
     *
     * @var collection
     */
    protected $form;

    /**
     * Variable to store form configuration.
     *
     * @var collection
     */
    protected $element;

    /**
     * Initialize the form.
     *
     * @return null
     */
    public function __construct()
    {
        $this->setForm();
    }

    /**
     * Return form elements.
     *
     * @return array.
     */
    public function form($element = 'fields', $grouped = true)
    {
        $item = collect($this->form->get($element));
        if ($element == 'fields' && $grouped == true) {
            return $item->groupBy(['group', 'section']);
        }
        return $item;

    }

    /**
     * Sets the form and form elements.
     * @return null.
     */
    public function setForm()
    {
        $this->form = collect([
            'form' => [
                'store' => [],
                'update' => [],
            ],
            'groups' => [
                'main' => 'Main',
            ],
            'fields' => [
                'ref' => [
                    "type" => 'text',
                    "label" => trans('database::call.label.ref'),
                    "placeholder" => trans('database::call.placeholder.ref'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'owner_id' => [
                    "type" => 'numeric',
                    "label" => trans('database::call.label.owner_id'),
                    "placeholder" => trans('database::call.placeholder.owner_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'assigned_at' => [
                    "type" => 'date_picker',
                    "label" => trans('database::call.label.assigned_at'),
                    "placeholder" => trans('database::call.placeholder.assigned_at'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'agent_id' => [
                    "type" => 'numeric',
                    "label" => trans('database::call.label.agent_id'),
                    "placeholder" => trans('database::call.placeholder.agent_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'contacted_at' => [
                    "type" => 'date_picker',
                    "label" => trans('database::call.label.contacted_at'),
                    "placeholder" => trans('database::call.placeholder.contacted_at'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'category_id' => [
                    "type" => 'numeric',
                    "label" => trans('database::call.label.category_id'),
                    "placeholder" => trans('database::call.placeholder.category_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'city_id' => [
                    "type" => 'numeric',
                    "label" => trans('database::call.label.city_id'),
                    "placeholder" => trans('database::call.placeholder.city_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'location_id' => [
                    "type" => 'numeric',
                    "label" => trans('database::call.label.location_id'),
                    "placeholder" => trans('database::call.placeholder.location_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'sublocation_id' => [
                    "type" => 'numeric',
                    "label" => trans('database::call.label.sublocation_id'),
                    "placeholder" => trans('database::call.placeholder.sublocation_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'property_id' => [
                    "type" => 'numeric',
                    "label" => trans('database::call.label.property_id'),
                    "placeholder" => trans('database::call.placeholder.property_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'building_no' => [
                    "type" => 'text',
                    "label" => trans('database::call.label.building_no'),
                    "placeholder" => trans('database::call.placeholder.building_no'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'customer_type' => [
                    "type" => 'text',
                    "label" => trans('database::call.label.customer_type'),
                    "placeholder" => trans('database::call.placeholder.customer_type'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'color' => [
                    "type" => 'text',
                    "label" => trans('database::call.label.color'),
                    "placeholder" => trans('database::call.placeholder.color'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'unit' => [
                    "type" => 'text',
                    "label" => trans('database::call.label.unit'),
                    "placeholder" => trans('database::call.placeholder.unit'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'plot' => [
                    "type" => 'text',
                    "label" => trans('database::call.label.plot'),
                    "placeholder" => trans('database::call.placeholder.plot'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'name' => [
                    "type" => 'text',
                    "label" => trans('database::call.label.name'),
                    "placeholder" => trans('database::call.placeholder.name'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'mobile' => [
                    "type" => 'text',
                    "label" => trans('database::call.label.mobile'),
                    "placeholder" => trans('database::call.placeholder.mobile'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'phone' => [
                    "type" => 'text',
                    "label" => trans('database::call.label.phone'),
                    "placeholder" => trans('database::call.placeholder.phone'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'email' => [
                    "type" => 'text',
                    "label" => trans('database::call.label.email'),
                    "placeholder" => trans('database::call.placeholder.email'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'notes' => [
                    "type" => 'text',
                    "label" => trans('database::call.label.notes'),
                    "placeholder" => trans('database::call.placeholder.notes'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'created_by' => [
                    "type" => 'numeric',
                    "label" => trans('database::call.label.created_by'),
                    "placeholder" => trans('database::call.placeholder.created_by'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
            ]
        );

    }
}
