<?php

namespace Bixo\Database\Forms;

class Database
{
    /**
     * Variable to store form configuration.
     *
     * @var collection
     */
    protected $form;

    /**
     * Variable to store form configuration.
     *
     * @var collection
     */
    protected $element;

    /**
     * Initialize the form.
     *
     * @return null
     */
    public function __construct()
    {
        $this->setForm();
    }

    /**
     * Return form elements.
     *
     * @return array.
     */
    public function form($element = 'fields', $grouped = true)
    {
        $item = collect($this->form->get($element));
        if ($element == 'fields' && $grouped == true) {
            return $item->groupBy(['group', 'section']);
        }
        return $item;

    }

    /**
     * Sets the form and form elements.
     * @return null.
     */
    public function setForm()
    {
        $this->form = collect([
            'form' => [
                'store' => [],
                'update' => [],
            ],
            'groups' => [
                'main' => 'Main',
            ],
            'fields' => [
                'ref' => [
                    "type" => 'text',
                    "label" => trans('database::database.label.ref'),
                    "placeholder" => trans('database::database.placeholder.ref'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'upload_id' => [
                    "type" => 'numeric',
                    "label" => trans('database::database.label.upload_id'),
                    "placeholder" => trans('database::database.placeholder.upload_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'contacted_at' => [
                    "type" => 'date_picker',
                    "label" => trans('database::database.label.contacted_at'),
                    "placeholder" => trans('database::database.placeholder.contacted_at'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'contacted_by' => [
                    "type" => 'numeric',
                    "label" => trans('database::database.label.contacted_by'),
                    "placeholder" => trans('database::database.placeholder.contacted_by'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'contacted_status' => [
                    "type" => 'text',
                    "label" => trans('database::database.label.contacted_status'),
                    "placeholder" => trans('database::database.placeholder.contacted_status'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'city_id' => [
                    "type" => 'numeric',
                    "label" => trans('database::database.label.city_id'),
                    "placeholder" => trans('database::database.placeholder.city_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'location_id' => [
                    "type" => 'numeric',
                    "label" => trans('database::database.label.location_id'),
                    "placeholder" => trans('database::database.placeholder.location_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'sublocation_id' => [
                    "type" => 'numeric',
                    "label" => trans('database::database.label.sublocation_id'),
                    "placeholder" => trans('database::database.placeholder.sublocation_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'property_id' => [
                    "type" => 'numeric',
                    "label" => trans('database::database.label.property_id'),
                    "placeholder" => trans('database::database.placeholder.property_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'building_no' => [
                    "type" => 'text',
                    "label" => trans('database::database.label.building_no'),
                    "placeholder" => trans('database::database.placeholder.building_no'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'bua' => [
                    "type" => 'numeric',
                    "label" => trans('database::database.label.bua'),
                    "placeholder" => trans('database::database.placeholder.bua'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'unit' => [
                    "type" => 'text',
                    "label" => trans('database::database.label.unit'),
                    "placeholder" => trans('database::database.placeholder.unit'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'plot' => [
                    "type" => 'text',
                    "label" => trans('database::database.label.plot'),
                    "placeholder" => trans('database::database.placeholder.plot'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'name' => [
                    "type" => 'text',
                    "label" => trans('database::database.label.name'),
                    "placeholder" => trans('database::database.placeholder.name'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'mobile' => [
                    "type" => 'text',
                    "label" => trans('database::database.label.mobile'),
                    "placeholder" => trans('database::database.placeholder.mobile'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'phone' => [
                    "type" => 'text',
                    "label" => trans('database::database.label.phone'),
                    "placeholder" => trans('database::database.placeholder.phone'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'email' => [
                    "type" => 'text',
                    "label" => trans('database::database.label.email'),
                    "placeholder" => trans('database::database.placeholder.email'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'created_by' => [
                    "type" => 'numeric',
                    "label" => trans('database::database.label.created_by'),
                    "placeholder" => trans('database::database.placeholder.created_by'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
            ]
        );

    }
}
