<?php

namespace Bixo\Database\Forms;

class Upload
{
    /**
     * Variable to store form configuration.
     *
     * @var collection
     */
    protected $form;

    /**
     * Variable to store form configuration.
     *
     * @var collection
     */
    protected $element;

    /**
     * Initialize the form.
     *
     * @return null
     */
    public function __construct()
    {
        $this->setForm();
    }

    /**
     * Return form elements.
     *
     * @return array.
     */
    public function form($element = 'fields', $grouped = true)
    {
        $item = collect($this->form->get($element));
        if ($element == 'fields' && $grouped == true) {
            return $item->groupBy(['group', 'section']);
        }
        return $item;

    }

    /**
     * Sets the form and form elements.
     * @return null.
     */
    public function setForm()
    {
        $this->form = collect([
            'form' => [
                'store' => [],
                'update' => [],
            ],
            'groups' => [
                'main' => 'Main',
            ],
            'fields' => [
                'city_id' => [
                    "type" => 'numeric',
                    "label" => trans('database::upload.label.city_id'),
                    "placeholder" => trans('database::upload.placeholder.city_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'location_id' => [
                    "type" => 'numeric',
                    "label" => trans('database::upload.label.location_id'),
                    "placeholder" => trans('database::upload.placeholder.location_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'sublocation_id' => [
                    "type" => 'numeric',
                    "label" => trans('database::upload.label.sublocation_id'),
                    "placeholder" => trans('database::upload.placeholder.sublocation_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'property_id' => [
                    "type" => 'numeric',
                    "label" => trans('database::upload.label.property_id'),
                    "placeholder" => trans('database::upload.placeholder.property_id'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'building_no' => [
                    "type" => 'text',
                    "label" => trans('database::upload.label.building_no'),
                    "placeholder" => trans('database::upload.placeholder.building_no'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'plot' => [
                    "type" => 'text',
                    "label" => trans('database::upload.label.plot'),
                    "placeholder" => trans('database::upload.placeholder.plot'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
                'file' => [
                    "type" => 'text',
                    "label" => trans('database::upload.label.file'),
                    "placeholder" => trans('database::upload.placeholder.file'),
                    "rules" => '',
                    "group" => "main",
                    "section" => "first",
                    "attributes" => [
                        'wrapper' => [],
                        "label" => [],
                        "input" => [],

                    ],
                ],
            ]
        );

    }
}
