<?php

namespace Bixo\Database\Http\Controllers;

use App\Http\Controllers\Controller as BaseController;
use Bixo\Database\Http\Requests\DatabaseRequest;
use Bixo\Database\Models\Database;

/**
 * Admin web controller class.
 */
class DatabaseWorkflowController extends BaseController
{

    /**
     * Workflow controller function for database.
     *
     * @param Model   $database
     * @param step    next step for the workflow.
     *
     * @return Response
     */

    public function putWorkflow(DatabaseRequest $request, Database $database, $step)
    {

        try {

            $database->updateWorkflow($step);

            return response()->json([
                'message'  => trans('messages.success.changed', ['Module' => trans('database::database.name'), 'status' => trans("app.{$step}")]),
                'code'     => 204,
                'redirect' => trans_url('/admin/database/database/' . $database->getRouteKey()),
            ], 201);

        } catch (Exception $e) {

            return response()->json([
                'message'  => $e->getMessage(),
                'code'     => 400,
                'redirect' => trans_url('/admin/database/database/' . $database->getRouteKey()),
            ], 400);

        }

    }

    /**
     * Workflow controller function for database.
     *
     * @param Model   $database
     * @param step    next step for the workflow.
     * @param user    encrypted user id.
     *
     * @return Response
     */

    public function getWorkflow(Database $database, $step, $user)
    {
        try {
            $user_id = decrypt($user);

            Auth::onceUsingId($user_id);

            $database->updateWorkflow($step);

            $data = [
                'message' => trans('messages.success.changed', ['Module' => trans('database::database.name'), 'status' => trans("app.{$step}")]),
                'status'  => 'success',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('database::admin.database.message', $data)->render();

        } catch (ValidationException $e) {

            $data = [
                'message' => '<b>' . $e->getMessage() . '</b> <br /><br />' . implode('<br />', $e->validator->errors()->all()),
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('database::admin.database.message', $data)->render();

        } catch (Exception $e) {

            $data = [
                'message' => '<b>' . $e->getMessage() . '</b>',
                'status'  => 'error',
                'step'    => trans("app.{$step}"),
            ];

            return $this->theme->layout('blank')->of('database::admin.database.message', $data)->render();

        }

    }
}
