<?php

namespace Bixo\Database\Policies;

use Litepie\User\Contracts\UserPolicy;
use Bixo\Database\Models\Call;

class CallPolicy
{

    /**
     * Determine if the given user can view the call.
     *
     * @param UserPolicy $user
     * @param Call $call
     *
     * @return bool
     */
    public function view(UserPolicy $user, Call $call)
    {
        if ($user->canDo('database.call.view') && $user->isAdmin()) {
            return true;
        }

        return $call->user_id == user_id() && $call->user_type == user_type();
    }

    /**
     * Determine if the given user can create a call.
     *
     * @param UserPolicy $user
     * @param Call $call
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('database.call.create');
    }

    /**
     * Determine if the given user can update the given call.
     *
     * @param UserPolicy $user
     * @param Call $call
     *
     * @return bool
     */
    public function update(UserPolicy $user, Call $call)
    {
        if ($user->canDo('database.call.edit') && $user->isAdmin()) {
            return true;
        }

        return $call->user_id == user_id() && $call->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given call.
     *
     * @param UserPolicy $user
     * @param Call $call
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Call $call)
    {
        return $call->user_id == user_id() && $call->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given call.
     *
     * @param UserPolicy $user
     * @param Call $call
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Call $call)
    {
        if ($user->canDo('database.call.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given call.
     *
     * @param UserPolicy $user
     * @param Call $call
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Call $call)
    {
        if ($user->canDo('database.call.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
