<?php

namespace Bixo\Database\Policies;

use Litepie\User\Contracts\UserPolicy;
use Bixo\Database\Models\Database;

class DatabasePolicy
{

    /**
     * Determine if the given user can view the database.
     *
     * @param UserPolicy $user
     * @param Database $database
     *
     * @return bool
     */
    public function view(UserPolicy $user, Database $database)
    {
        if ($user->canDo('database.database.view') && $user->isAdmin()) {
            return true;
        }

        return $database->user_id == user_id() && $database->user_type == user_type();
    }

    /**
     * Determine if the given user can create a database.
     *
     * @param UserPolicy $user
     * @param Database $database
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('database.database.create');
    }

    /**
     * Determine if the given user can update the given database.
     *
     * @param UserPolicy $user
     * @param Database $database
     *
     * @return bool
     */
    public function update(UserPolicy $user, Database $database)
    {
        if ($user->canDo('database.database.edit') && $user->isAdmin()) {
            return true;
        }

        return $database->user_id == user_id() && $database->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given database.
     *
     * @param UserPolicy $user
     * @param Database $database
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Database $database)
    {
        return $database->user_id == user_id() && $database->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given database.
     *
     * @param UserPolicy $user
     * @param Database $database
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Database $database)
    {
        if ($user->canDo('database.database.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given database.
     *
     * @param UserPolicy $user
     * @param Database $database
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Database $database)
    {
        if ($user->canDo('database.database.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
