<?php

namespace Bixo\Database\Policies;

use Litepie\User\Contracts\UserPolicy;
use Bixo\Database\Models\Upload;

class UploadPolicy
{

    /**
     * Determine if the given user can view the upload.
     *
     * @param UserPolicy $user
     * @param Upload $upload
     *
     * @return bool
     */
    public function view(UserPolicy $user, Upload $upload)
    {
        if ($user->canDo('database.upload.view') && $user->isAdmin()) {
            return true;
        }

        return $upload->user_id == user_id() && $upload->user_type == user_type();
    }

    /**
     * Determine if the given user can create a upload.
     *
     * @param UserPolicy $user
     * @param Upload $upload
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('database.upload.create');
    }

    /**
     * Determine if the given user can update the given upload.
     *
     * @param UserPolicy $user
     * @param Upload $upload
     *
     * @return bool
     */
    public function update(UserPolicy $user, Upload $upload)
    {
        if ($user->canDo('database.upload.edit') && $user->isAdmin()) {
            return true;
        }

        return $upload->user_id == user_id() && $upload->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given upload.
     *
     * @param UserPolicy $user
     * @param Upload $upload
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Upload $upload)
    {
        return $upload->user_id == user_id() && $upload->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given upload.
     *
     * @param UserPolicy $user
     * @param Upload $upload
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Upload $upload)
    {
        if ($user->canDo('database.upload.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given upload.
     *
     * @param UserPolicy $user
     * @param Upload $upload
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Upload $upload)
    {
        if ($user->canDo('database.upload.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
