<?php

namespace Bixo\Database\Providers;

use Illuminate\Contracts\Auth\Access\Gate as GateContract;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the package.
     *
     * @var array
     */
    protected $policies = [
        // Bind Call policy
        'Bixo\Database\Models\Call' => \Bixo\Database\Policies\CallPolicy::class,// Bind Database policy
        'Bixo\Database\Models\Database' => \Bixo\Database\Policies\DatabasePolicy::class,// Bind Upload policy
        'Bixo\Database\Models\Upload' => \Bixo\Database\Policies\UploadPolicy::class,
    ];

    /**
     * Register any package authentication / authorization services.
     *
     * @param \Illuminate\Contracts\Auth\Access\Gate $gate
     *
     * @return void
     */
    public function boot(GateContract $gate)
    {
        parent::registerPolicies($gate);
    }
}
