<?php

namespace Bixo\Database\Providers;

use Illuminate\Support\ServiceProvider;

class DatabaseServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'database');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'database');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerDatabase();
        $this->registerFacade();
        $this->registerBindings();
        //$this->registerCommands();
    }


    /**
     * Register the application bindings.
     *
     * @return void
     */
    protected function registerDatabase()
    {
        $this->app->bind('database', function($app) {
            return new Database($app);
        });
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->booting(function()
        {
            $loader = \Illuminate\Foundation\AliasLoader::getInstance();
            $loader->alias('Database', 'Lavalite\Database\Facades\Database');
        });
    }

    /**
     * Register bindings for the provider.
     *
     * @return void
     */
    public function registerBindings() {
        // Bind facade
        $this->app->bind('bixo.database', function ($app) {
            return $this->app->make('Bixo\Database\Database');
        });

        // Bind Call to repository
        $this->app->bind(
            'Bixo\Database\Interfaces\CallRepositoryInterface',
            \Bixo\Database\Repositories\Eloquent\CallRepository::class
        );        // Bind Database to repository
        $this->app->bind(
            'Bixo\Database\Interfaces\DatabaseRepositoryInterface',
            \Bixo\Database\Repositories\Eloquent\DatabaseRepository::class
        );        // Bind Upload to repository
        $this->app->bind(
            'Bixo\Database\Interfaces\UploadRepositoryInterface',
            \Bixo\Database\Repositories\Eloquent\UploadRepository::class
        );

        $this->app->register(\Bixo\Database\Providers\AuthServiceProvider::class);
                $this->app->register(\Bixo\Database\Providers\EventServiceProvider::class);
        
        $this->app->register(\Bixo\Database\Providers\RouteServiceProvider::class);
                // $this->app->register(\Bixo\Database\Providers\WorkflowServiceProvider::class);
            }

    /**
     * Merges user's and database's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/config.php', 'bixo.database'
        );
    }

    /**
     * Register scaffolding command
     */
    protected function registerCommands()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                Commands\MakeDatabase::class,
            ]);
        }
    }
    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['bixo.database'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('bixo/database.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/database')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/database')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
