<?php

namespace Bixo\Database\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Routing\Router;
use Bixo\Database\Models\Database;
use Request;
use Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * This namespace is applied to the controller routes in your routes file.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */
    protected $namespace = 'Bixo\Database\Http\Controllers';

    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @param   \Illuminate\Routing\Router  $router
     * @return void
     */
    public function boot()
    {
        parent::boot();

        if (Request::is('*/database/call/*')) {
            Route::bind('call', function ($call) {
                $callrepo = $this->app->make('Bixo\Database\Interfaces\CallRepositoryInterface');
                return $callrepo->findorNew($call);
            });
        }
        if (Request::is('*/database/database/*')) {
            Route::bind('database', function ($database) {
                $databaserepo = $this->app->make('Bixo\Database\Interfaces\DatabaseRepositoryInterface');
                return $databaserepo->findorNew($database);
            });
        }
        if (Request::is('*/database/upload/*')) {
            Route::bind('upload', function ($upload) {
                $uploadrepo = $this->app->make('Bixo\Database\Interfaces\UploadRepositoryInterface');
                return $uploadrepo->findorNew($upload);
            });
        }

    }

    /**
     * Define the routes for the package.
     *
     * @return void
     */
    public function map()
    {
        $this->mapWebRoutes();

        $this->mapApiRoutes();
    }

    /**
     * Define the "web" routes for the package.
     *
     * These routes all receive session state, CSRF protection, etc.
     *
     * @return void
     */
    protected function mapWebRoutes()
    {   
        Route::group([
            'middleware' => 'web',
            'namespace'  => $this->namespace,
        ], function ($router) {
            require (__DIR__ . '/../../routes/web.php');
        });
    }

    /**
     * Define the "api" routes for the package.
     *
     * These routes are typically stateless.
     *
     * @return void
     */
    protected function mapApiRoutes()
    {
        Route::group([
            'middleware' => 'api',
            'namespace'  => $this->namespace,
            'prefix'     => 'api',
        ], function ($router) {
            require (__DIR__ . '/../../routes/api.php');
        });
    }

}
