<?php

namespace Bixo\Database\Providers;

use Litepie\Contracts\Workflow\Workflow as WorkflowContract;
use Litepie\Foundation\Support\Providers\WorkflowServiceProvider as ServiceProvider;

class WorkflowServiceProvider extends ServiceProvider
{
    /**
     * The validators mappings for the package.
     *
     * @var array
     */
    protected $validators = [
        // Bind Call workflow validator
        'Bixo\Database\Models\Call' => \Bixo\Database\Workflow\CallValidator::class,
        // Bind Database workflow validator
        'Bixo\Database\Models\Database' => \Bixo\Database\Workflow\DatabaseValidator::class,
        // Bind Upload workflow validator
        'Bixo\Database\Models\Upload' => \Bixo\Database\Workflow\UploadValidator::class,
    ];

    /**
     * The actions mappings for the package.
     *
     * @var array
     */
    protected $actions = [
        // Bind Call workflow actions
        'Bixo\Database\Models\Call' => \Bixo\Database\Workflow\CallAction::class,
        // Bind Database workflow actions
        'Bixo\Database\Models\Database' => \Bixo\Database\Workflow\DatabaseAction::class,
        // Bind Upload workflow actions
        'Bixo\Database\Models\Upload' => \Bixo\Database\Workflow\UploadAction::class,
    ];

    /**
     * The notifiers mappings for the package.
     *
     * @var array
     */
    protected $notifiers = [
       // Bind Call workflow notifiers
        'Bixo\Database\Models\Call' => \Bixo\Database\Workflow\CallNotifier::class,
        // Bind Database workflow notifiers
        'Bixo\Database\Models\Database' => \Bixo\Database\Workflow\DatabaseNotifier::class,
        // Bind Upload workflow notifiers
        'Bixo\Database\Models\Upload' => \Bixo\Database\Workflow\UploadNotifier::class,
    ];

    /**
     * Register any package workflow validation services.
     *
     * @param \Litepie\Contracts\Workflow\Workflow $workflow
     *
     * @return void
     */
    public function boot(WorkflowContract $workflow)
    {
        parent::registerValidators($workflow);
        parent::registerActions($workflow);
        parent::registerNotifiers($workflow);
    }
}
