<?php

namespace Bixo\Database\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class CallTransformer extends TransformerAbstract
{
    public function transform(\Bixo\Database\Models\Call $call)
    {
        return [
            'id'                => $call->getRouteKey(),
            'key'               => [
                'public'    => $call->getPublicKey(),
                'route'     => $call->getRouteKey(),
            ], 
            'ref'               => $call->ref,
            'owner_id'          => $call->owner_id,
            'assigned_at'       => $call->assigned_at,
            'agent_id'          => $call->agent_id,
            'contacted_at'      => $call->contacted_at,
            'category_id'       => $call->category_id,
            'city_id'           => $call->city_id,
            'location_id'       => $call->location_id,
            'sublocation_id'    => $call->sublocation_id,
            'property_id'       => $call->property_id,
            'building_no'       => $call->building_no,
            'customer_type'     => $call->customer_type,
            'color'             => $call->color,
            'unit'              => $call->unit,
            'plot'              => $call->plot,
            'name'              => $call->name,
            'mobile'            => $call->mobile,
            'phone'             => $call->phone,
            'email'             => $call->email,
            'notes'             => $call->notes,
            'created_by'        => $call->created_by,
            'deleted_at'        => $call->deleted_at,
            'url'               => [
                'public'    => trans_url('database/'.$call->getPublicKey()),
                'user'      => guard_url('database/call/'.$call->getRouteKey()),
            ], 
            'status'            => trans('app.'.$call->status),
            'created_at'        => format_date($call->created_at),
            'updated_at'        => format_date($call->updated_at),
        ];
    }
}