<?php

namespace Bixo\Database\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class DatabaseTransformer extends TransformerAbstract
{
    public function transform(\Bixo\Database\Models\Database $database)
    {
        return [
            'id'                => $database->getRouteKey(),
            'key'               => [
                'public'    => $database->getPublicKey(),
                'route'     => $database->getRouteKey(),
            ], 
            'ref'               => $database->ref,
            'upload_id'         => $database->upload_id,
            'contacted_at'      => $database->contacted_at,
            'contacted_by'      => $database->contacted_by,
            'contacted_status'  => $database->contacted_status,
            'city_id'           => $database->city_id,
            'location_id'       => $database->location_id,
            'sublocation_id'    => $database->sublocation_id,
            'property_id'       => $database->property_id,
            'building_no'       => $database->building_no,
            'bua'               => $database->bua,
            'unit'              => $database->unit,
            'plot'              => $database->plot,
            'name'              => $database->name,
            'mobile'            => $database->mobile,
            'phone'             => $database->phone,
            'email'             => $database->email,
            'created_by'        => $database->created_by,
            'deleted_at'        => $database->deleted_at,
            'url'               => [
                'public'    => trans_url('database/'.$database->getPublicKey()),
                'user'      => guard_url('database/database/'.$database->getRouteKey()),
            ], 
            'status'            => trans('app.'.$database->status),
            'created_at'        => format_date($database->created_at),
            'updated_at'        => format_date($database->updated_at),
        ];
    }
}