<?php

namespace Bixo\Database\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class UploadTransformer extends TransformerAbstract
{
    public function transform(\Bixo\Database\Models\Upload $upload)
    {
        return [
            'id'                => $upload->getRouteKey(),
            'key'               => [
                'public'    => $upload->getPublicKey(),
                'route'     => $upload->getRouteKey(),
            ], 
            'city_id'           => $upload->city_id,
            'location_id'       => $upload->location_id,
            'sublocation_id'    => $upload->sublocation_id,
            'property_id'       => $upload->property_id,
            'building_no'       => $upload->building_no,
            'plot'              => $upload->plot,
            'file'              => $upload->file,
            'slug'              => $upload->slug,
            'user_id'           => $upload->user_id,
            'deleted_at'        => $upload->deleted_at,
            'url'               => [
                'public'    => trans_url('database/'.$upload->getPublicKey()),
                'user'      => guard_url('database/upload/'.$upload->getRouteKey()),
            ], 
            'status'            => trans('app.'.$upload->status),
            'created_at'        => format_date($upload->created_at),
            'updated_at'        => format_date($upload->updated_at),
        ];
    }
}