<?php

namespace Bixo\Database\Workflow;

use Exception;
use Litepie\Workflow\Exceptions\WorkflowActionNotPerformedException;

use Bixo\Database\Models\Call;

class CallAction
{
    /**
     * Perform the complete action.
     *
     * @param Call $call
     *
     * @return Call
     */
    public function complete(Call $call)
    {
        try {
            $call->status = 'complete';
            return $call->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the verify action.
     *
     * @param Call $call
     *
     * @return Call
     */public function verify(Call $call)
    {
        try {
            $call->status = 'verify';
            return $call->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the approve action.
     *
     * @param Call $call
     *
     * @return Call
     */public function approve(Call $call)
    {
        try {
            $call->status = 'approve';
            return $call->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the publish action.
     *
     * @param Call $call
     *
     * @return Call
     */public function publish(Call $call)
    {
        try {
            $call->status = 'publish';
            return $call->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the archive action.
     *
     * @param Call $call
     *
     * @return Call
     */
    public function archive(Call $call)
    {
        try {
            $call->status = 'archive';
            return $call->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the unpublish action.
     *
     * @param Call $call
     *
     * @return Call
     */
    public function unpublish(Call $call)
    {
        try {
            $call->status = 'unpublish';
            return $call->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }
}
